<?php
// application_form.php - Public Form

require_once 'config.php';
require_once 'layout.php';
require_once 'application_handler.php';

$message = '';
$error = false;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $result = handle_application_submission($_POST); 
    if ($result === true) {
        $message = 'Application submitted successfully! We will review it shortly.';
    } else {
        $error = true;
        $message = 'Submission failed: ' . htmlspecialchars($result);
    }
}

render_header("Whitelist Application", 'public');
?>

<div class="py-12 px-4">
    <div class="max-w-3xl mx-auto">
        
        <!-- Header -->
        <div class="text-center mb-10">
            <div class="inline-block p-4 rounded-full bg-dark-800 mb-4 border border-dark-700 shadow-xl">
                <i class="fa-solid fa-scroll text-4xl text-primary-500"></i>
            </div>
            <h1 class="text-4xl font-bold text-white mb-2">Server Whitelist</h1>
            <p class="text-gray-400">Join our community by completing the application below.</p>
        </div>

        <?php if ($message): ?>
            <div class="mb-8 p-6 rounded-2xl <?php echo $error ? 'bg-red-500/10 border-red-500/50 text-red-300' : 'bg-green-500/10 border-green-500/50 text-green-300'; ?> border flex items-start gap-4 shadow-lg">
                <i class="fa-solid <?php echo $error ? 'fa-circle-xmark' : 'fa-circle-check'; ?> text-2xl mt-0.5"></i>
                <div>
                    <h3 class="font-bold text-lg"><?php echo $error ? 'Whoops!' : 'Success!'; ?></h3>
                    <p class="mt-1"><?php echo htmlspecialchars($message); ?></p>
                </div>
            </div>
        <?php endif; ?>

        <form method="POST" action="application_form.php" class="space-y-8">
            
            <!-- Section 1: Personal Info -->
            <div class="bg-dark-800 p-8 rounded-2xl border border-dark-700 shadow-xl">
                <h3 class="text-xl font-bold text-white mb-6 flex items-center">
                    <span class="w-8 h-8 rounded-lg bg-primary-600 text-white flex items-center justify-center text-sm mr-3">1</span>
                    Personal Information
                </h3>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="col-span-1 md:col-span-2">
                        <label class="block text-sm font-medium text-gray-400 mb-2">Email Address *</label>
                        <input type="email" name="email" required class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-primary-500 focus:border-transparent outline-none transition">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-2">Full Name *</label>
                        <input type="text" name="full_name" required class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-primary-500 outline-none transition">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-2">Date of Birth *</label>
                        <input type="date" name="date_of_birth" required class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-primary-500 outline-none transition">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-2">Country & Timezone</label>
                        <input type="text" name="country_timezone" class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-primary-500 outline-none transition">
                    </div>
                </div>
            </div>

            <!-- Section 2: Account Details -->
            <div class="bg-dark-800 p-8 rounded-2xl border border-dark-700 shadow-xl">
                <h3 class="text-xl font-bold text-white mb-6 flex items-center">
                    <span class="w-8 h-8 rounded-lg bg-primary-600 text-white flex items-center justify-center text-sm mr-3">2</span>
                    Account Details
                </h3>

                <div class="space-y-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">Steam Profile Link *</label>
                            <input type="text" name="steam_link" required placeholder="https://steamcommunity.com/..." class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-primary-500 outline-none transition">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">Steam Profile Name *</label>
                            <input type="text" name="steam_profile_name" required class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-primary-500 outline-none transition">
                        </div>
                    </div>
                    
                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-2">Steam Hex ID *</label>
                        <input type="text" name="steam_hex_id" required placeholder="1100001..." class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-primary-500 outline-none transition font-mono">
                        <p class="text-xs text-gray-500 mt-1">You can find this on websites like vacbanned.com</p>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">Discord Username *</label>
                            <div class="relative">
                                <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-500"><i class="fa-brands fa-discord"></i></span>
                                <input type="text" name="discord_username" required placeholder="username" class="w-full bg-dark-900 border border-dark-700 rounded-xl pl-10 p-3 text-white focus:ring-2 focus:ring-primary-500 outline-none transition">
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-400 mb-2">Discord ID *</label>
                            <input type="text" name="discord_id" required class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-primary-500 outline-none transition font-mono">
                        </div>
                    </div>
                </div>
            </div>

            <!-- Section 3: Questionnaire -->
            <div class="bg-dark-800 p-8 rounded-2xl border border-dark-700 shadow-xl">
                <h3 class="text-xl font-bold text-white mb-6 flex items-center">
                    <span class="w-8 h-8 rounded-lg bg-primary-600 text-white flex items-center justify-center text-sm mr-3">3</span>
                    Roleplay Questions
                </h3>

                <div class="space-y-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-2">Explain "Roleplay" in your own words *</label>
                        <textarea name="roleplay_explanation" rows="4" required class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-primary-500 outline-none transition"></textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-2">Explain "New Life Rule" (NLR) *</label>
                        <textarea name="new_life_rules_explanation" rows="4" required class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-primary-500 outline-none transition"></textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-400 mb-3">Previous Roleplay Experience? *</label>
                        <div class="flex gap-6">
                            <label class="flex items-center cursor-pointer group">
                                <div class="relative">
                                    <input type="radio" name="previous_roleplay_experience" value="Yes" class="peer sr-only">
                                    <div class="w-6 h-6 border-2 border-dark-600 rounded-full peer-checked:border-primary-500 peer-checked:bg-primary-500 transition"></div>
                                </div>
                                <span class="ml-3 text-gray-300 group-hover:text-white">Yes</span>
                            </label>
                            <label class="flex items-center cursor-pointer group">
                                <div class="relative">
                                    <input type="radio" name="previous_roleplay_experience" value="No" class="peer sr-only">
                                    <div class="w-6 h-6 border-2 border-dark-600 rounded-full peer-checked:border-primary-500 peer-checked:bg-primary-500 transition"></div>
                                </div>
                                <span class="ml-3 text-gray-300 group-hover:text-white">No</span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Section 4: Agreements -->
            <div class="bg-dark-800 p-6 rounded-2xl border border-dark-700 shadow-xl">
                <div class="space-y-4">
                    <label class="flex items-start cursor-pointer group p-3 rounded-lg hover:bg-dark-700/50 transition">
                        <div class="relative mt-0.5">
                            <input type="checkbox" name="read_rulebook" value="Yes" required class="peer sr-only">
                            <div class="w-5 h-5 border-2 border-dark-600 rounded peer-checked:bg-primary-500 peer-checked:border-primary-500 transition flex items-center justify-center">
                                <i class="fa-solid fa-check text-xs text-white opacity-0 peer-checked:opacity-100"></i>
                            </div>
                        </div>
                        <span class="ml-3 text-sm text-gray-300 group-hover:text-white select-none">I have read and understood the Server Rulebook.</span>
                    </label>

                    <label class="flex items-start cursor-pointer group p-3 rounded-lg hover:bg-dark-700/50 transition">
                        <div class="relative mt-0.5">
                            <input type="checkbox" name="agree_to_rules" value="Yes" required class="peer sr-only">
                            <div class="w-5 h-5 border-2 border-dark-600 rounded peer-checked:bg-primary-500 peer-checked:border-primary-500 transition flex items-center justify-center">
                                <i class="fa-solid fa-check text-xs text-white opacity-0 peer-checked:opacity-100"></i>
                            </div>
                        </div>
                        <span class="ml-3 text-sm text-gray-300 group-hover:text-white select-none">I agree to follow all community guidelines and rules.</span>
                    </label>
                </div>
            </div>

            <button type="submit" class="w-full bg-gradient-to-r from-primary-600 to-indigo-600 hover:from-primary-500 hover:to-indigo-500 text-white font-bold text-lg py-4 rounded-xl shadow-lg shadow-primary-500/30 transition transform hover:-translate-y-1">
                Submit Application
            </button>

        </form>
    </div>
</div>

<?php render_footer(); ?>