<?php
// interview_queue.php - Modern Interview Dashboard
require_once 'config.php';
require_once 'layout.php';
require_once 'application_handler.php';

session_start();

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin.php');
    exit;
}

$action_message = '';
$error_message = '';

if (isset($_POST['app_id'], $_POST['action'])) {
    $result = handle_application_action($_POST['app_id'], $_POST['action'], $_POST['reason'] ?? null);
    $result['success'] ? $action_message = $result['message'] : $error_message = $result['message'];
}

$applications = get_applications();
$interview_apps = array_filter($applications, function($app) {
    return $app['status'] === 'waiting_for_interview';
});

render_header("Interview Queue", 'dashboard');
?>

<div class="mb-8 animate-fade-in">
    <h2 class="text-3xl font-bold text-white tracking-tight">Interview Queue</h2>
    <p class="text-gray-400 mt-1">Applicants waiting for voice verification.</p>
</div>

<?php if ($action_message): ?>
    <div class="mb-6 p-4 rounded-xl bg-green-500/10 border border-green-500/30 text-green-400 flex items-center shadow-lg">
        <i class="fa-solid fa-check-circle mr-2"></i> <?php echo htmlspecialchars($action_message); ?>
    </div>
<?php endif; ?>

<div class="glass-panel rounded-3xl overflow-hidden shadow-2xl">
    <div class="p-6 border-b border-dark-700 bg-dark-800/80 flex justify-between items-center">
        <div class="flex items-center gap-3">
             <div class="w-10 h-10 rounded-full bg-primary-500/10 flex items-center justify-center text-primary-500">
                <i class="fa-solid fa-microphone-lines"></i>
            </div>
            <h3 class="text-lg font-bold text-white">Ready for Interview</h3>
        </div>
        <span class="bg-primary-600 px-3 py-1 rounded-full text-white text-xs font-bold shadow-lg shadow-primary-600/30">
            <?php echo count($interview_apps); ?> Waiting
        </span>
    </div>

    <?php if (empty($interview_apps)): ?>
        <div class="p-20 text-center flex flex-col items-center">
            <div class="w-20 h-20 bg-dark-800 rounded-full flex items-center justify-center mb-6 border border-dark-700">
                <i class="fa-solid fa-mug-hot text-3xl text-gray-600"></i>
            </div>
            <h3 class="text-xl font-bold text-white">Queue Empty</h3>
            <p class="text-gray-400 mt-2">No interviews pending at this time.</p>
        </div>
    <?php else: ?>
        <div class="grid grid-cols-1 gap-4 p-6">
            <?php foreach ($interview_apps as $app): ?>
                <div class="bg-dark-800 rounded-2xl border border-dark-700 p-6 flex flex-col lg:flex-row justify-between lg:items-center gap-6 hover:border-primary-500/30 transition-all duration-300">
                    
                    <div class="flex items-center gap-5">
                        <div class="w-16 h-16 rounded-xl bg-gradient-to-br from-primary-600 to-indigo-700 flex items-center justify-center text-2xl font-bold text-white shadow-xl">
                            <?php echo strtoupper(substr($app['discord_username'], 0, 1)); ?>
                        </div>
                        <div>
                            <h4 class="text-xl font-bold text-white"><?php echo htmlspecialchars($app['full_name']); ?></h4>
                            <div class="flex items-center gap-3 mt-1.5">
                                <span class="text-sm text-gray-400 bg-dark-900 px-2 py-0.5 rounded border border-dark-700 font-mono">
                                    <i class="fa-brands fa-discord mr-1"></i> <?php echo htmlspecialchars($app['discord_username']); ?>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="flex flex-wrap gap-3">
                        <!-- Use Global Modal -->
                        <button onclick='openViewModal(<?php echo json_encode($app); ?>)' class="px-4 py-2.5 bg-dark-700 hover:bg-dark-600 text-gray-200 rounded-xl font-medium transition flex items-center">
                            <i class="fa-solid fa-file-lines mr-2"></i> View Full App
                        </button>
                        
                        <form method="POST" onsubmit="return confirm('Whitelist User?');">
                            <input type="hidden" name="app_id" value="<?php echo $app['id']; ?>">
                            <input type="hidden" name="action" value="whitelist">
                            <button type="submit" class="px-5 py-2.5 bg-green-600 hover:bg-green-500 text-white rounded-xl font-bold shadow-lg shadow-green-600/20 transition flex items-center">
                                <i class="fa-solid fa-check-double mr-2"></i> Pass & Whitelist
                            </button>
                        </form>

                        <button onclick="showDeclineModal('<?php echo $app['id']; ?>', 'interview_queue.php')" class="px-4 py-2.5 bg-red-500/10 hover:bg-red-500 text-red-500 hover:text-white border border-red-500/20 rounded-xl font-medium transition">
                            <i class="fa-solid fa-xmark"></i>
                        </button>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<!-- Re-use Modal Script/HTML from Layout/Admin -->
<div id="decline-modal" class="fixed inset-0 bg-black/80 backdrop-blur-sm hidden z-[110] flex items-center justify-center p-4">
    <div class="bg-dark-800 border border-dark-700 w-full max-w-md rounded-2xl shadow-2xl p-6">
        <h3 class="text-xl font-bold text-white mb-2">Decline Application</h3>
        <p class="text-gray-400 text-sm mb-6">Reason for rejection:</p>
        <form method="POST" id="decline-form">
            <input type="hidden" name="app_id" id="decline-app-id" value="">
            <input type="hidden" name="action" value="decline">
            <textarea name="reason" rows="4" required class="w-full bg-dark-900 border border-dark-700 rounded-xl p-3 text-white focus:ring-2 focus:ring-red-500 outline-none mb-4 resize-none"></textarea>
            <div class="flex justify-end gap-3">
                <button type="button" onclick="document.getElementById('decline-modal').classList.add('hidden')" class="px-4 py-2 rounded-lg text-gray-400 hover:text-white hover:bg-dark-700 transition">Cancel</button>
                <button type="submit" class="px-4 py-2 bg-red-600 hover:bg-red-500 text-white rounded-lg font-bold transition">Confirm</button>
            </div>
        </form>
    </div>
</div>
<script>
    function showDeclineModal(appId, page) {
        document.getElementById('decline-app-id').value = appId;
        document.getElementById('decline-form').action = page;
        document.getElementById('decline-modal').classList.remove('hidden');
    }
</script>

<?php render_footer(); ?>